package w83b.w83bOperacionesInternas.w83bResultados;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class W83bResultadosOIAction.
 * 
 * @author a
 */
public class W83bResultadosBucleOIAction extends Q70OperacionInterna{
	
	/**
	 * preProcessMappingEntrada.
	 * 
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
				
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
		resultadoBean.setIdioma(idioma);
		String contarResultados = (String)contexto.get("contarResultados");
		
		if(StringUtils.isNotEmpty(contarResultados)){
			if(10000<Integer.parseInt(contarResultados)){
				resultadoBean.setMin(resultadoBean.getMax());
				if(Integer.parseInt(resultadoBean.getMax()) + 10000
						>Integer.parseInt(contarResultados)){
					resultadoBean.setMax(contarResultados);
					resultadoBean.setModo(resultadoBean.getModo()+"ultimaIt");
//					W83bClsTrazas.trazaError(null, "partida -> "+contarResultados, null);
				}else{
					resultadoBean.setMax(String.valueOf(Integer.parseInt(resultadoBean.getMax()) + 10000));
//					W83bClsTrazas.trazaError(null, "partida -> 100", null);
				}
			}else{
				resultadoBean.setMax(contarResultados);	
				resultadoBean.setMin(contarResultados);
			}
		}
		
		contexto.set("w83bResultadosBean",resultadoBean);
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	
	/**
	 * postProcessMappingSalida.
	 * 
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
		if(null!=resultadoBean
				&&StringUtils.isNotEmpty(resultadoBean.getModo())
				&&-1!=resultadoBean.getModo().indexOf("ultimaIt")){
			resultadoBean.setModo(resultadoBean.getModo().substring(0,resultadoBean.getModo().indexOf("ultimaIt")));
			contexto.set("w83bResultadosBean",resultadoBean);
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}
	
}
